// Create Morse Code script to read message from serial port and flash a led as needed.

int ledPin = 13;
char* letters[] = {
  ".-", "-...", "-.-.", "-..", ".", "..-.", "--.", "....", "..", // A-I
  ".---", "-.-", ".-..", "--", "-.", "---", ".--.", "--.-", ".-.", // J-R
  "...", "-", "..-", "...-", ".--", "-..-", "-.--", "--.." // S-Z
};

char* numbers[] = {"-----", ".----", "..---", "...--", "....-", ".....", "-....",
  "--...", "---..", "----."};

int dotDelay = 200;

void setup(){
  pinMode(ledPin, OUTPUT);
  Serial.begin(9600);
}

void loop(){
  char ch;
  if(Serial.available()){
    ch = Serial.read();
    if(ch >= 'a' && ch <= 'z'){
      flashSequence(letters[ch - 'a']);
    } else if (ch >= 'A' && ch <= 'Z'){
                flashSequence(letters[ch - 'A']);
              } else if (ch >= '0' && ch <= '9'){
                          flashSequence(numbers[ch - '0']);
                        } else if (ch == ' '){
                                    delay(dotDelay * 4);
                                  }
  }
}

void flashSequence(char* sequence){
  int i= 0;
  while (sequence[i] != NULL){
    flashDotorDash(sequence[i]);
    i++;
  }
  delay(dotDelay * 3);
}

void flashDotorDash(char dotOrDash){
  digitalWrite(ledPin, HIGH);
  if (dotOrDash == '.'){
    delay(dotDelay);
  } else // it must be a dash
    {
      delay(dotDelay * 3);
    }
  digitalWrite(ledPin, LOW);
  delay(dotDelay);
}
