/*
  * Motor Knob
  * 
  * A stepper motor advances 1 step each time a switch changes its state
  * 
  * We use the Adafruit stepper motor library (AFMotor.h) and 
  * board to drive an Epson EM234 stepper motor on port2 (M3-M4)
  * 
  * Spyros Veronikis
*/

#include <AFMotor.h>
#include <AccelStepper.h>

int DIpin = 21;

AF_Stepper motor(48, 2);    // Create a motor instance
                            // AF_Stepper(steps, stepper#) 

void setup(){
  Serial.begin(9600);
  Serial.println("Press the switch on input 21");
  pinMode(DIpin, INPUT);
  motor.setSpeed(10);      // Set the rpm value

  motor.step(10, FORWARD, SINGLE);  // Perform 10 steps forward.
  motor.release();        
  delay(2000);                      // Wait for 2 seconds
}

void loop(){
  int DIstatus = digitalRead(DIpin);
  
  if (DIstatus != HIGH){    // Filter out big displacements
    Serial.println(DIstatus);
    motor.step(10, FORWARD, SINGLE);
    motor.release();
   }
   delay(100);  
}
